#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TimeZone : BaseTest 
	{
		private const char TestTimeZoneID = 'A';
		private const char AnotherTestTimeZoneID = 'B';
		private const string TestTimeZoneLongName = "Central European";
		private const string TestTimeZoneStandardTimeText = "CET ";
		private const char NonExistentTimeZoneID = 'J';

		private BOL.TimeZone _testTZ;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testTZ = new BOL.TimeZone( TestTimeZoneID );
		}

		[TearDown]
		protected void TearDown()
		{
			_testTZ = null;
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull( _testTZ );
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_Fail()
		{
			new BOL.TimeZone( NonExistentTimeZoneID );
		}

		private DataRow GetTestDataRow()
		{
			DataRow _dr = GetTestDataTable().NewRow();

			_dr[ TABLES.TimeZone.TimeZoneId ] = TestTimeZoneID;
			_dr[ TABLES.TimeZone.TimeZoneName ] = TestTimeZoneLongName;
			_dr[ TABLES.TimeZone.StandardTimeText ] = TestTimeZoneStandardTimeText;

			return _dr;
		}

		private DataTable GetTestDataTable()
		{
			DataTable _dt = new DataTable();

			_dt.Columns.Add( TABLES.TimeZone.TimeZoneId, typeof(char) );
			_dt.Columns.Add( TABLES.TimeZone.TimeZoneName, typeof(string) );
			_dt.Columns.Add( TABLES.TimeZone.StandardTimeText, typeof(string) );

			return _dt;
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			_testTZ = new BOL.TimeZone( TestTimeZoneID );
			DataRow _dr = GetTestDataTable().NewRow();
			_testTZ.LoadDataRowFromThis( _dr );

			Assert.AreEqual( Convert.ToChar( _dr[ TABLES.TimeZone.TimeZoneId ] ), TestTimeZoneID );
			Assert.AreEqual( Convert.ToString( _dr[ TABLES.TimeZone.TimeZoneName ] ), TestTimeZoneLongName );
			Assert.AreEqual( Convert.ToString( _dr[ TABLES.TimeZone.StandardTimeText ] ), TestTimeZoneStandardTimeText );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LoadDataRowFromThis_Fail()
		{
			_testTZ.LoadDataRowFromThis( null );
		}

		[Test]
		public void GetAll_Pass()
		{
			Assert.AreEqual( 25, BOL.TimeZone.GetAll().Count );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetAll_Fail() {}

		[Test]
		public void ID_Pass()
		{
			Assert.AreEqual( TestTimeZoneID, _testTZ.ID );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ID_Fail(){}

		[Test]
		public void LongName_Pass()
		{
			Assert.AreEqual( TestTimeZoneLongName, _testTZ.LongName );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void LongName_Fail(){}

		[Test]
		public void StandardTimeText_Pass()
		{
			Assert.AreEqual( TestTimeZoneStandardTimeText, _testTZ.StandardTimeText );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void StandardTimeText_Fail(){}

		[Test]
		public void GetObjectID_Pass()
		{
			Assert.AreEqual( TestTimeZoneID, _testTZ.GetObjectID() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetObjectID_Fail() {}

		[Test]
		public void GetAllSortedByName_Pass()
		{
			Assert.IsTrue( BOL.TimeZone.GetAllSortedByName().Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetAllSortedByName_Fail() {}
	}
}
#endif
